<?php
namespace addons\haibao;
use think\Addons;
use think\Db;

/**
 * 海报管理插件
 */
class Haibao extends Addons
{
    // 插件的基础信息
    public $info = [
        'name' => 'haibao',
        'title' => '南轩海报管理',
        'description' => '方便管理影视海报和推荐显示',
        'status' => 0,
        'author' => '南轩',
        'version' => '1.0.2'
    ];

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        // 添加快捷菜单
        $path = 'application/data/config/quickmenu.txt';
        $info = '海报管理,/addons/haibao/index.php';
        
        $quickmenu = '';
        $config_menu = config('quickmenu');
        if (!empty($config_menu) && !in_array($info, $config_menu)) {
            $quickmenu = array_values($config_menu);
            $quickmenu = join(chr(13), $quickmenu);
            $quickmenu = $quickmenu . chr(13) . chr(10) . $info;
            
            $quickmenu = str_replace(chr(10), '', $quickmenu);
            $menu_arr = explode(chr(13), $quickmenu);
            mac_arr2file(APP_PATH . 'extra/quickmenu.php', $menu_arr);
        }
        
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        // 移除快捷菜单
        $path = 'application/data/config/quickmenu.txt';
        $info = '海报管理,/addons/haibao/index.php';
        
        $quickmenu = '';
        $config_menu = config('quickmenu');
        if (!empty($config_menu) && in_array($info, $config_menu)) {
            $arr = [];
            foreach ($config_menu as $k => $v) {
                if ($v != $info) {
                    $arr[] = $v;
                }
            }
            
            $quickmenu = join(chr(13), $arr);
            $quickmenu = str_replace(chr(10), '', $quickmenu);
            $menu_arr = explode(chr(13), $quickmenu);
            mac_arr2file(APP_PATH . 'extra/quickmenu.php', $menu_arr);
        }
        
        return true;
    }
    
    /**
     * 实现的adminMainMenuAfter钩子方法
     */
    public function adminMainMenuAfter()
    {
        return $this->fetch('menu');
    }
    
    /**
     * 实现后台首页快捷菜单钩子方法
     */
    public function adminIndexCms()
    {
        // 渲染快捷菜单项
        return $this->fetch('shortcut');
    }
} 