# 海报管理插件

## 插件介绍

海报管理插件是一款专为苹果CMS开发的强大海报管理工具，可以帮助站长快速添加、管理和定时更新网站首页的推荐内容，提升用户体验和网站美观度。

## 功能特点

- **手动添加海报**：根据影片名称快速添加推荐内容
- **随机添加海报**：一键批量添加推荐内容，节省时间
- **管理当前海报**：查看、编辑和删除已添加的推荐内容
- **定时自动更新**：设置定时任务，自动更新首页推荐内容
- **分类筛选功能**：按分类筛选内容，精准推荐
- **灵活的推荐等级**：9级推荐等级设置，满足不同位置展示需求

## 安装要求

- 苹果CMS V10+
- PHP 7.0+
- MySQL 5.5+
- 支持cURL或allow_url_fopen

## 安装步骤

1. 下载插件压缩包
2. 解压并上传插件文件夹到网站的 `/addons/` 目录下,给予haibao文件夹777权限
3. 登录苹果CMS后台
4. 进入【插件管理】页面
5. 找到【海报管理】插件，点击【安装】
6. 安装完成后，点击【管理】进入海报管理界面

## 使用说明

### 1. 手动添加海报

适用于精确添加特定内容到推荐位。

1. 进入【手动添加】选项卡
2. 输入影片名称（必须是数据库中已有的影片）
3. 选择分类（可选）
4. 选择推荐等级（1-9级，9级为最高）
5. 点击【添加海报】按钮

### 2. 随机添加海报

适用于快速批量添加内容到推荐位。

1. 进入【随机添加】选项卡
2. 选择分类（可选）
3. 设置添加数量（1-50）
4. 选择推荐等级
5. 点击【随机添加】按钮

### 3. 管理当前海报

查看、编辑和删除已添加的推荐内容。

1. 进入【当前海报】选项卡
2. 可以看到所有已添加的海报列表
3. 支持单个取消推荐或批量取消
4. 支持全部取消推荐

### 4. 定时配置

设置自动更新海报的定时任务。

1. 进入【定时配置】选项卡
2. 开启/关闭定时更新
3. 选择分类和更新数量
4. 选择推荐等级
5. 设置是否在更新前清空当前推荐
6. 保存配置
7. 复制提供的定时任务URL，在服务器的计划任务中设置

#### 宝塔面板定时任务设置

1. 登录宝塔面板
2. 进入【计划任务】
3. 添加计划任务
4. 任务类型选择【访问URL】
5. 填写URL地址（即插件提供的定时任务URL）
6. 设置执行周期（如每天凌晨2点）
7. 保存设置

## 插件结构

```
haibao/
├── admin/                # 管理员界面相关文件
├── api/                  # API接口文件
│   ├── add_poster.php    # 添加海报API
│   ├── cancel_poster.php # 取消海报API
│   ├── get_posters.php   # 获取海报列表API
│   ├── random_add.php    # 随机添加API
│   └── schedule_update.php # 定时更新处理
├── assets/               # 静态资源文件
│   ├── css/              # CSS样式文件
│   ├── js/               # JavaScript文件
│   └── img/              # 图片资源
├── cache/                # 缓存目录
├── includes/             # 核心功能文件
│   └── ad_loader.php     # 广告加载器
├── config/               # 配置文件目录
├── tools/                # 辅助工具
├── view/                 # 视图模板
├── index.php             # 插件主入口
├── Haibao.php            # 插件核心类
├── config.php            # 插件配置
├── install.php           # 安装脚本
├── info.ini              # 插件信息
└── README.md             # 说明文档
```

## 使用技巧

1. **合理设置推荐等级**：
   - 9级通常用于置顶内容
   - 不同位置可使用不同推荐等级

2. **分类筛选使用建议**：
   - 首页可以使用全部分类
   - 分类页面建议使用对应分类的内容

3. **定时更新配置建议**：
   - 网站流量较大时，建议在访问量低的时段执行更新
   - 更新频率建议设置为每天1-2次
   - 更新数量不宜过多，建议10-20个为宜

4. **性能优化**：
   - 已添加缓存机制，提高加载速度
   - 定期清理缓存目录，保持系统流畅

## 常见问题

**Q: 添加海报时提示"影片不存在"怎么办？**

A: 请确认输入的影片名称在数据库中存在，且拼写完全一致。可以在后台影片管理中查询确认。

**Q: 定时更新不生效怎么办？**

A: 检查以下几点：
1. 确认定时更新开关已开启
2. 确认服务器计划任务已正确设置
3. 检查URL访问是否有权限或防火墙限制
4. 查看服务器错误日志获取详细信息

**Q: 如何修改推荐海报的展示样式？**

A: 推荐海报的展示样式由主题模板决定，需要修改主题的相关模板文件。

**Q: 如何完全卸载插件？**

A: 在后台插件管理中卸载，然后手动删除 `/addons/haibao/` 目录。

