<?php
/**
 * 广告服务状态检查
 */

header('Content-Type: application/json; charset=utf-8');

// 广告服务器地址
$ad_server = "https://hb.itcxo.cn/maccms";

// 检查服务器连接状态
function check_server($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $result = curl_exec($ch);
    
    if (curl_errno($ch)) {
        curl_close($ch);
        return false;
    }
    
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return $http_code >= 200 && $http_code < 300;
}

// 获取广告数据
function get_ads($url) {
    $ch = curl_init($url . "/index.php?action=get&t=" . time());
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $result = curl_exec($ch);
    
    if (curl_errno($ch)) {
        curl_close($ch);
        return ['error' => 'CURL错误: ' . curl_error($ch)];
    }
    
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code >= 200 && $http_code < 300) {
        try {
            $data = json_decode($result, true);
            if (json_last_error() === JSON_ERROR_NONE) {
                return $data;
            } else {
                return ['error' => 'JSON解析错误: ' . json_last_error_msg(), 'raw' => substr($result, 0, 200)];
            }
        } catch (Exception $e) {
            return ['error' => '数据解析异常: ' . $e->getMessage()];
        }
    }
    
    return ['error' => 'HTTP错误: ' . $http_code, 'raw' => substr($result, 0, 200)];
}

// 执行检查
$server_status = check_server($ad_server);
$ad_data = $server_status ? get_ads($ad_server) : null;

// 返回结果
echo json_encode([
    'success' => true,
    'server_status' => $server_status ? 'online' : 'offline',
    'ad_enabled' => $ad_data && isset($ad_data['data']['enabled']) ? $ad_data['data']['enabled'] : false,
    'ad_count' => $ad_data && isset($ad_data['data']['ads']) ? count($ad_data['data']['ads']) : 0,
    'timestamp' => time(),
    'server_url' => $ad_server,
    'raw_data' => isset($ad_data['error']) ? $ad_data : null // 只在有错误时返回原始数据
]); 