<?php
// 处理广告配置
header('Content-Type: application/json; charset=utf-8');

// 引入共享函数库
require_once __DIR__ . '/common_functions.php';

// 配置文件路径
$configDir = __DIR__ . '/../config';
$configFile = $configDir . '/ads.json';

// 确保配置目录存在
if (!is_dir($configDir)) {
    if (!@mkdir($configDir, 0755, true)) {
        outputJson([], 1, '无法创建配置目录，请检查权限');
    }
}

// 获取请求方法
$method = $_SERVER['REQUEST_METHOD'];

// 根据请求方法处理不同操作
if ($method === 'POST') {
    // 保存配置
    $data = $_POST;
    
    // 处理广告数据
    $ads = [];
    if (isset($data['ads']) && is_array($data['ads'])) {
        foreach ($data['ads'] as $ad) {
            // 验证必要字段
            if (!empty($ad['text']) && !empty($ad['url'])) {
                $ads[] = [
                    'text' => trim($ad['text']),
                    'url' => trim($ad['url']),
                    'color' => !empty($ad['color']) ? trim($ad['color']) : '#1E9FFF',
                    'is_custom' => isset($ad['is_custom']) ? (bool)$ad['is_custom'] : false
                ];
            }
        }
    }
    
    $config = [
        'enabled' => isset($data['enabled']) && ($data['enabled'] === 'on' || $data['enabled'] === '1' || $data['enabled'] === 'true'),
        'ads' => $ads,
        'lastUpdate' => time()
    ];
    
    // 使用JSON_PRETTY_PRINT使JSON文件更易读
    // 使用JSON_UNESCAPED_UNICODE确保中文字符正确显示
    $jsonOptions = JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE;
    
    // 保存到JSON文件
    $result = @file_put_contents($configFile, json_encode($config, $jsonOptions));
    if ($result === false) {
        outputJson([], 1, '配置保存失败，请检查文件权限');
    } else {
        outputJson($config, 0, '广告配置保存成功');
    }
} else {
    // 获取配置
    if (file_exists($configFile)) {
        $configContent = @file_get_contents($configFile);
        if ($configContent === false) {
            outputJson([], 1, '无法读取配置文件，请检查权限');
        }
        
        $config = @json_decode($configContent, true);
        if ($config === null) {
            outputJson([], 1, 'JSON格式错误，配置文件可能已损坏');
        }
        
        outputJson($config, 0, '获取广告配置成功');
    } else {
        // 默认配置
        $defaultConfig = [
            'enabled' => true,
            'ads' => [
                ['text' => '至尊解析/官方一解/购买送1w+切片资源', 'url' => '#', 'color' => '#FF5722', 'is_custom' => true],
                ['text' => '二免费 | 无广告解析 | 官网采集 | 蓝光超清', 'url' => '#', 'color' => '#009688', 'is_custom' => true],
                ['text' => '【推荐】官源同步更新 购买采集授权送解析', 'url' => '#', 'color' => '#FF00FF', 'is_custom' => true],
                ['text' => '【推荐】官方资源站 永久无水印', 'url' => '#', 'color' => '#FF0000', 'is_custom' => true],
                ['text' => '方能CDN 助力欧洲杯 免费测试', 'url' => '#', 'color' => '#00BFFF', 'is_custom' => true],
                ['text' => '【官方推荐】SGV蓝光切片-秒播放超稳定', 'url' => '#', 'color' => '#FF0000', 'is_custom' => true],
                ['text' => '一广告联盟推荐-联盟跑量-全额付款—', 'url' => '#', 'color' => '#0000FF', 'is_custom' => true],
                ['text' => '无广告解析 | 官方弹幕 | 蓝光超清', 'url' => '#', 'color' => '#000000', 'is_custom' => true],
                ['text' => '88联盟高价收一切真实量', 'url' => '#', 'color' => '#00FF00', 'is_custom' => true],
                ['text' => '【推荐】Ace切片-官方同步-在线秒播', 'url' => '#', 'color' => '#00BFFF', 'is_custom' => true],
                ['text' => '名商解析/官解+官采/去插播+切片资源', 'url' => '#', 'color' => '#008000', 'is_custom' => true],
                ['text' => '【稳定】蓝光资源 | 万部短剧 | 价格美丽', 'url' => '#', 'color' => '#00CED1', 'is_custom' => true],
                ['text' => '建安云 不坐台 可接影视 U支付', 'url' => '#', 'color' => '#4169E1', 'is_custom' => true],
                ['text' => '【官方推荐】即客云切片-秒播-独家APP', 'url' => '#', 'color' => '#0000FF', 'is_custom' => true],
                ['text' => '【风吹云】香港特惠活动只需9.9元起', 'url' => '#', 'color' => '#FF00FF', 'is_custom' => true],
                ['text' => '❤️华为吧资源07位置❤️华为吧资源❤️', 'url' => '#', 'color' => '#FF0000', 'is_custom' => true],
                ['text' => '❤️华为吧资源❤️国内CDN秒播秒播❤️', 'url' => '#', 'color' => '#FF0000', 'is_custom' => true],
                ['text' => '❤️华为吧资源❤️晚上高峰秒播不卡❤️', 'url' => '#', 'color' => '#FF0000', 'is_custom' => true],
                ['text' => '❤️华为吧资源❤️片源丰富分类齐全❤️', 'url' => '#', 'color' => '#FF0000', 'is_custom' => true],
                ['text' => '如意资源', 'url' => '#', 'color' => '#FF0000', 'is_custom' => true]
            ],
            'lastUpdate' => time()
        ];
        
        // 尝试创建默认配置文件
        $jsonOptions = JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE;
        @file_put_contents($configFile, json_encode($defaultConfig, $jsonOptions));
        
        outputJson($defaultConfig, 0, '使用默认广告配置');
    }
} 