<?php
// 处理海报添加
header('Content-Type: application/json; charset=utf-8');

// 引入共享函数库
require_once __DIR__ . '/common_functions.php';

// 获取POST数据
$movieName = isset($_POST['movieName']) ? trim($_POST['movieName']) : '';
$recommendLevel = isset($_POST['recommendLevel']) ? intval($_POST['recommendLevel']) : 9;
$typeId = isset($_POST['typeId']) ? intval($_POST['typeId']) : null;

if (empty($movieName)) {
    outputJson([], 1, '请输入海报名称');
}

// 使用通用函数获取数据库配置
$dbConfig = getSystemDbConfig();

// 连接数据库
try {
    $conn = new mysqli($dbConfig['dbHost'], $dbConfig['dbUser'], $dbConfig['dbPass'], $dbConfig['dbName'], $dbConfig['dbPort']);
    
    if ($conn->connect_error) {
        outputJson([], 1, '数据库连接失败: ' . $conn->connect_error);
    }
    
    // 设置字符集
    $conn->set_charset('utf8');
    
    // 查询数据库
    $sql = "SELECT vod_name, vod_pic_slide, vod_level FROM mac_vod WHERE vod_name = ?";
    if ($typeId !== null) {
        $sql .= " AND type_id = ?";
    }
    
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        outputJson([], 1, "准备查询语句失败: " . $conn->error);
    }
    
    if ($typeId !== null) {
        $stmt->bind_param("si", $movieName, $typeId);
    } else {
        $stmt->bind_param("s", $movieName);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        // 更新推荐等级
        $updateSql = "UPDATE mac_vod SET vod_level = ? WHERE vod_name = ?";
        if ($typeId !== null) {
            $updateSql .= " AND type_id = ?";
        }
        
        $updateStmt = $conn->prepare($updateSql);
        
        if ($updateStmt === false) {
            outputJson([], 1, "准备更新推荐等级语句失败: " . $conn->error);
        }
        
        if ($typeId !== null) {
            $updateStmt->bind_param("isi", $recommendLevel, $movieName, $typeId);
        } else {
            $updateStmt->bind_param("is", $recommendLevel, $movieName);
        }
        
        $updateStmt->execute();
        
        // 从API获取数据并存储
        $haibaoData = getHaibaoData();
        
        if (empty($haibaoData)) {
            outputJson([], 1, "无法从API获取海报数据");
        }
        
        $updated = false;
        $typeName = $typeId ? getTypeName($typeId, $conn) : '';
        
        foreach ($haibaoData as $item) {
            if ($item['name'] === $movieName && ($typeId === null || $item['source'] === $typeName)) {
                $updateSlideSql = "UPDATE mac_vod SET vod_pic_slide = ? WHERE vod_name = ?";
                if ($typeId !== null) {
                    $updateSlideSql .= " AND type_id = ?";
                }
                
                $updateSlideStmt = $conn->prepare($updateSlideSql);
                
                if ($updateSlideStmt === false) {
                    outputJson([], 1, "准备更新海报链接语句失败: " . $conn->error);
                }
                
                if ($typeId !== null) {
                    $updateSlideStmt->bind_param("ssi", $item['url'], $movieName, $typeId);
                } else {
                    $updateSlideStmt->bind_param("ss", $item['url'], $movieName);
                }
                
                $updateSlideStmt->execute();
                $updated = true;
                
                outputJson([
                    'name' => $movieName,
                    'url' => $item['url'],
                    'level' => $recommendLevel
                ], 0, "成功添加了《{$movieName}》的海报,当前推荐为 {$recommendLevel}");
                break;
            }
        }
        
        if (!$updated) {
            outputJson([], 1, "没有找到《{$movieName}》对应的海报信息。");
        }
    } else {
        outputJson([], 1, "没有找到对应的影片名称。");
    }
    
    $conn->close();
    
} catch (Exception $e) {
    outputJson([], 1, "发生错误: " . $e->getMessage());
} 