<?php
// 处理取消海报推荐
header('Content-Type: application/json; charset=utf-8');

// 引入共享函数库
require_once __DIR__ . '/common_functions.php';

// 获取POST数据
$action = isset($_POST['action']) ? $_POST['action'] : '';
$selected_posters = isset($_POST['poster']) ? $_POST['poster'] : [];

if (empty($action)) {
    outputJson([], 1, '未指定操作类型');
}

// 使用通用函数获取数据库配置
$dbConfig = getSystemDbConfig();

// 连接数据库
try {
    $conn = new mysqli($dbConfig['dbHost'], $dbConfig['dbUser'], $dbConfig['dbPass'], $dbConfig['dbName'], $dbConfig['dbPort']);
    
    if ($conn->connect_error) {
        outputJson([], 1, '数据库连接失败: ' . $conn->connect_error);
    }
    
    // 设置字符集
    $conn->set_charset('utf8');
    
    if ($action == 'cancel_selected' && !empty($selected_posters)) {
        $cancelled_posters = [];
        
        foreach ($selected_posters as $vod_name) {
            $vod_name = $conn->real_escape_string($vod_name);
            $sql = "UPDATE mac_vod SET vod_level = 0 WHERE vod_name = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param('s', $vod_name);
            
            if ($stmt->execute()) {
                $cancelled_posters[] = $vod_name;
            }
        }
        
        if (count($cancelled_posters) > 0) {
            outputJson($cancelled_posters, 0, '取消推荐成功：' . implode(', ', $cancelled_posters));
        } else {
            outputJson([], 1, '取消推荐失败，请重试');
        }
    } elseif ($action == 'cancel_all') {
        $sql = "UPDATE mac_vod SET vod_level = 0 WHERE vod_level != 0";
        
        if ($conn->query($sql) === TRUE) {
            outputJson([], 0, '所有推荐海报已取消');
        } else {
            outputJson([], 1, '取消所有推荐失败，请重试');
        }
    } else {
        outputJson([], 1, '无效的操作请求');
    }
    
    $conn->close();
    
} catch (Exception $e) {
    outputJson([], 1, "发生错误: " . $e->getMessage());
} 