<?php
// 获取已推荐的海报列表
header('Content-Type: application/json; charset=utf-8');

// 引入共享函数库
require_once __DIR__ . '/common_functions.php';

// 使用通用函数获取数据库配置
$dbConfig = getSystemDbConfig();

// 连接数据库
try {
    $conn = new mysqli($dbConfig['dbHost'], $dbConfig['dbUser'], $dbConfig['dbPass'], $dbConfig['dbName'], $dbConfig['dbPort']);
    
    if ($conn->connect_error) {
        outputJson([], 1, '数据库连接失败: ' . $conn->connect_error);
    }
    
    // 设置字符集
    $conn->set_charset('utf8');
    
    // 查询推荐的海报
    $sql = "SELECT vod_id, vod_name, vod_pic, vod_pic_slide, vod_level, type_id 
            FROM mac_vod 
            WHERE vod_level > 0 
            ORDER BY vod_level DESC, vod_time DESC";
    
    $result = $conn->query($sql);
    
    if ($result === false) {
        outputJson([], 1, "查询失败: " . $conn->error);
    }
    
    $posters = [];
    
    while ($row = $result->fetch_assoc()) {
        // 获取分类名称
        $typeName = getTypeName($row['type_id'], $conn);
        
        $posters[] = [
            'vod_id' => $row['vod_id'],
            'vod_name' => $row['vod_name'],
            'vod_pic' => $row['vod_pic'],
            'vod_pic_slide' => $row['vod_pic_slide'],
            'vod_level' => $row['vod_level'],
            'type_id' => $row['type_id'],
            'type_name' => $typeName
        ];
    }
    
    outputJson($posters, 0, '获取海报列表成功');
    
    $conn->close();
    
} catch (Exception $e) {
    outputJson([], 1, "发生错误: " . $e->getMessage());
} 