<?php
// 处理随机添加海报
header('Content-Type: application/json; charset=utf-8');

// 引入共享函数库
require_once __DIR__ . '/common_functions.php';

// 获取POST数据
$count = isset($_POST['count']) ? intval($_POST['count']) : 1;
$recommendLevel = isset($_POST['recommendLevel']) ? intval($_POST['recommendLevel']) : 9;
$typeId = isset($_POST['typeId']) ? intval($_POST['typeId']) : null;

if ($count <= 0 || $count > 100) {
    $count = 1;
}

// 使用通用函数获取数据库配置
$dbConfig = getSystemDbConfig();

// 连接数据库
try {
    $conn = new mysqli($dbConfig['dbHost'], $dbConfig['dbUser'], $dbConfig['dbPass'], $dbConfig['dbName'], $dbConfig['dbPort']);
    
    if ($conn->connect_error) {
        outputJson([], 1, '数据库连接失败: ' . $conn->connect_error);
    }
    
    // 设置字符集
    $conn->set_charset('utf8');
    
    // 从海报网获取数据
    $haibaoData = getHaibaoData();
    
    if (empty($haibaoData)) {
        outputJson([], 1, "海报网返回的数据为空");
    }
    
    // 如果指定了分类，获取分类名称
    $typeName = '';
    if ($typeId !== null) {
        $typeName = getTypeName($typeId, $conn);
    }
    
    // 过滤符合条件的海报
    $filteredData = [];
    foreach ($haibaoData as $item) {
    if ($typeId === null || (isset($item['source']) && $item['source'] === $typeName)) {
        $filteredData[] = $item;
    }
}
    
    if (empty($filteredData)) {
        outputJson([], 1, "没有找到符合条件的海报");
    }
    
    // 随机选择海报
    $updatedMovies = [];
    $attempts = 0;
    $maxAttempts = 100; // 设置最大尝试次数，防止无限循环
    
    shuffle($filteredData); // 随机排序数组
    
    while (count($updatedMovies) < $count && $attempts < $maxAttempts) {
        if (empty($filteredData)) {
            break; // 如果没有更多海报可选
        }
        
        $randomItem = array_shift($filteredData); // 取出第一个元素
        $movieName = $randomItem['name'];
        
        // 查询数据库中是否存在相同的电影名称
        $sql = "SELECT vod_name, vod_pic_slide, vod_level FROM mac_vod WHERE vod_name = ?";
        if ($typeId !== null) {
            $sql .= " AND type_id = ?";
        }
        
        $stmt = $conn->prepare($sql);
        
        if ($stmt === false) {
            $attempts++;
            continue; // 跳过错误的条目
        }
        
        if ($typeId !== null) {
            $stmt->bind_param("si", $movieName, $typeId);
        } else {
            $stmt->bind_param("s", $movieName);
        }
        
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            // 更新推荐等级和海报链接
            $updateSql = "UPDATE mac_vod SET vod_level = ?, vod_pic_slide = ? WHERE vod_name = ?";
            if ($typeId !== null) {
                $updateSql .= " AND type_id = ?";
            }
            
            $updateStmt = $conn->prepare($updateSql);
            
            if ($updateStmt !== false) {
                if ($typeId !== null) {
                    $updateStmt->bind_param("issi", $recommendLevel, $randomItem['url'], $movieName, $typeId);
                } else {
                    $updateStmt->bind_param("iss", $recommendLevel, $randomItem['url'], $movieName);
                }
                
                $updateStmt->execute();
                $updatedMovies[] = [
                    'name' => $movieName,
                    'url' => $randomItem['url']
                ];
            }
        }
        
        $attempts++;
    }
    
    if (!empty($updatedMovies)) {
        $movieNames = array_column($updatedMovies, 'name');
        outputJson($updatedMovies, 0, "成功更新 " . count($updatedMovies) . " 个海报，当前推荐为 {$recommendLevel}。推荐名称：" . implode(", ", $movieNames));
    } else {
        outputJson([], 1, "没有找到符合条件的影片。");
    }
    
    $conn->close();
    
} catch (Exception $e) {
    outputJson([], 1, "发生错误: " . $e->getMessage());
} 