<?php
// 处理定时配置保存和获取
header('Content-Type: application/json; charset=utf-8');

// 引入共享函数库
require_once __DIR__ . '/common_functions.php';

// 配置文件路径
$configDir = __DIR__ . '/../config';
$configFile = $configDir . '/schedule.json';

// 确保配置目录存在
if (!is_dir($configDir)) {
    if (!@mkdir($configDir, 0755, true)) {
        outputJson([], 1, '无法创建配置目录，请检查权限');
    }
}

// 获取请求方法
$method = $_SERVER['REQUEST_METHOD'];

// 根据请求方法处理不同操作
if ($method === 'POST') {
    // 保存配置
    $data = $_POST;
    
    // 确保布尔值正确处理
    $enabled = isset($data['enabled']) && ($data['enabled'] === 'on' || $data['enabled'] === '1' || $data['enabled'] === 'true');
    $clearBeforeUpdate = isset($data['clearBeforeUpdate']) && ($data['clearBeforeUpdate'] === 'on' || $data['clearBeforeUpdate'] === '1' || $data['clearBeforeUpdate'] === 'true');
    
    $config = [
        'enabled' => $enabled, // 强制转换为布尔值
        'typeId' => isset($data['typeId']) ? intval($data['typeId']) : 0,
        'count' => isset($data['count']) ? intval($data['count']) : 10,
        'recommendLevel' => isset($data['recommendLevel']) ? intval($data['recommendLevel']) : 9,
        'clearBeforeUpdate' => $clearBeforeUpdate, // 强制转换为布尔值
        'lastUpdate' => time()
    ];
    
    // 使用JSON_PRETTY_PRINT使JSON文件更易读
    // 使用JSON_UNESCAPED_UNICODE确保中文字符正确显示
    $jsonOptions = JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE;
    
    // 保存到JSON文件
    $result = @file_put_contents($configFile, json_encode($config, $jsonOptions));
    if ($result === false) {
        outputJson([], 1, '配置保存失败，请检查文件权限');
    } else {
        // 返回正确的布尔值
        outputJson($config, 0, '配置保存成功');
    }
} else {
    // 获取配置
    if (file_exists($configFile)) {
        $configContent = @file_get_contents($configFile);
        if ($configContent === false) {
            // 无法读取文件
            outputJson([], 1, '无法读取配置文件，请检查权限');
        }
        
        $config = @json_decode($configContent, true);
        if ($config === null) {
            // JSON解析错误
            outputJson([], 1, 'JSON格式错误，配置文件可能已损坏');
        }
        
        // 确保布尔值正确
        if (isset($config['enabled'])) {
            $config['enabled'] = (bool)$config['enabled'];
        }
        if (isset($config['clearBeforeUpdate'])) {
            $config['clearBeforeUpdate'] = (bool)$config['clearBeforeUpdate'];
        }
        
        outputJson($config, 0, '获取配置成功');
    } else {
        // 默认配置
        $defaultConfig = [
            'enabled' => false,
            'typeId' => 0,
            'count' => 10,
            'recommendLevel' => 9,
            'clearBeforeUpdate' => false,
            'lastUpdate' => 0
        ];
        
        // 尝试创建默认配置文件
        $jsonOptions = JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE;
        @file_put_contents($configFile, json_encode($defaultConfig, $jsonOptions));
        
        outputJson($defaultConfig, 0, '使用默认配置');
    }
} 