<?php
/**
 * 更新检查API
 */
header('Content-Type: application/json; charset=utf-8');

// 引入通用函数
require_once __DIR__ . '/common_functions.php';

// 当前插件版本
define('CURRENT_VERSION', '1.2.0');

// 更新服务器地址
$update_server = "https://hb.itcxo.cn/maccms";

// 检查更新
function check_for_updates() {
    global $update_server;
    
    // 创建cURL资源
    $ch = curl_init();
    
    // 设置URL和相应的选项
    curl_setopt($ch, CURLOPT_URL, $update_server . "/update/check.php?version=" . CURRENT_VERSION);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    // 获取响应
    $response = curl_exec($ch);
    
    // 检查请求是否成功
    if(curl_errno($ch)) {
        return [
            'success' => false,
            'error' => 'cURL Error: ' . curl_error($ch),
            'current_version' => CURRENT_VERSION
        ];
    }
    
    // 关闭cURL资源
    curl_close($ch);
    
    // 解析响应
    $data = json_decode($response, true);
    
    if (!$data) {
        return [
            'success' => false,
            'error' => '无法解析服务器响应',
            'current_version' => CURRENT_VERSION
        ];
    }
    
    // 添加当前版本信息
    $data['current_version'] = CURRENT_VERSION;
    
    return $data;
}

// 获取更新信息
$update_info = check_for_updates();

// 输出更新信息
echo json_encode($update_info); 