<?php
/**
 * 更新下载和安装API
 */

// 引入通用函数
require_once __DIR__ . '/common_functions.php';

// 检查权限
if (!function_exists('is_admin') || !is_admin()) {
    header('HTTP/1.1 403 Forbidden');
    echo "权限不足，只有管理员可以执行更新操作";
    exit;
}

// 更新服务器地址
$update_server = "https://hb.itcxo.cn/maccms";

// 防止超时
set_time_limit(300);
ini_set('memory_limit', '256M');

// 创建临时目录
$temp_dir = __DIR__ . '/../temp';
if (!is_dir($temp_dir)) {
    mkdir($temp_dir, 0755, true);
}

// 获取更新版本号
$version = isset($_GET['version']) ? $_GET['version'] : '';
if (empty($version)) {
    outputJson([], 1, '未指定版本号');
}

// 下载更新包
$update_file = $temp_dir . '/update_' . $version . '.zip';
$download_url = $update_server . "/update/download.php?version=" . $version;

// 下载文件
$fp = fopen($update_file, 'w+');
$ch = curl_init($download_url);
curl_setopt($ch, CURLOPT_TIMEOUT, 300);
curl_setopt($ch, CURLOPT_FILE, $fp);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
$success = curl_exec($ch);

if(!$success) {
    outputJson([], 1, '下载更新包失败: ' . curl_error($ch));
}

curl_close($ch);
fclose($fp);

// 解压更新包
$zip = new ZipArchive;
$res = $zip->open($update_file);
if ($res !== true) {
    outputJson([], 1, '无法打开更新包: ' . $res);
}

// 解压到插件目录
$target_dir = __DIR__ . '/..';
$zip->extractTo($target_dir);
$zip->close();

// 删除临时文件
unlink($update_file);

// 更新版本信息
$version_file = $target_dir . '/version.json';
file_put_contents($version_file, json_encode([
    'version' => $version,
    'updated_at' => date('Y-m-d H:i:s')
]));

// 清理缓存
if (function_exists('opcache_reset')) {
    opcache_reset();
}

// 返回成功信息
outputJson([
    'version' => $version,
    'updated_at' => date('Y-m-d H:i:s')
], 0, '更新成功完成！插件已更新到版本 ' . $version); 