layui.use(['layer', 'form', 'element'], function() {
    var $ = layui.jquery;
    var layer = layui.layer;
    var form = layui.form;
    var element = layui.element;
    
    // 初始化加载
    loadRecommendedPosters();
    
    // 监听选项卡切换
    element.on('tab(posterTabs)', function(data){
        if(data.index === 2) { // 当切换到第三个选项卡(已推荐海报)时重新加载数据
            loadRecommendedPosters();
        }
    });
    
    // 监听手动添加海报表单提交
    form.on('submit(addPoster)', function(data) {
        var loading = layer.load(2);
        
        $.ajax({
            url: '?action=add_poster',
            type: 'POST',
            data: data.field,
            success: function(res) {
                layer.close(loading);
                
                if (res.code === 0) {
                    layer.msg(res.msg, {icon: 1});
                    // 清空表单
                    $('#add-poster-form')[0].reset();
                    form.render();
                    // 切换到已推荐海报选项卡
                    element.tabChange('posterTabs', 2);
                    // 重新加载海报列表
                    loadRecommendedPosters();
                } else {
                    layer.msg(res.msg, {icon: 2});
                }
            },
            error: function() {
                layer.close(loading);
                layer.msg('提交请求失败，请重试', {icon: 2});
            }
        });
        
        return false; // 阻止表单跳转
    });
    
    // 监听随机添加海报表单提交
    form.on('submit(randomAdd)', function(data) {
        var loading = layer.load(2);
        
        $.ajax({
            url: '?action=random_add',
            type: 'POST',
            data: data.field,
            success: function(res) {
                layer.close(loading);
                
                if (res.code === 0) {
                    layer.msg(res.msg, {icon: 1});
                    // 切换到已推荐海报选项卡
                    element.tabChange('posterTabs', 2);
                    // 重新加载海报列表
                    loadRecommendedPosters();
                } else {
                    layer.msg(res.msg, {icon: 2});
                }
            },
            error: function() {
                layer.close(loading);
                layer.msg('提交请求失败，请重试', {icon: 2});
            }
        });
        
        return false; // 阻止表单跳转
    });
    
    // 取消所有海报推荐
    $('#cancel-all').click(function() {
        layer.confirm('确定要取消所有推荐海报吗？此操作不可恢复！', {
            btn: ['确定','取消'],
            title: '警告',
            icon: 3
        }, function(index){
            layer.close(index);
            
            var loading = layer.load(2);
            
            $.ajax({
                url: '?action=cancel_poster',
                type: 'POST',
                data: {
                    action: 'cancel_all'
                },
                success: function(res) {
                    layer.close(loading);
                    
                    if (res.code === 0) {
                        layer.msg(res.msg, {icon: 1});
                        // 重新加载海报列表
                        loadRecommendedPosters();
                    } else {
                        layer.msg(res.msg, {icon: 2});
                    }
                },
                error: function() {
                    layer.close(loading);
                    layer.msg('请求失败，请重试', {icon: 2});
                }
            });
        });
    });
    
    // 取消选中的海报推荐
    $('#cancel-selected').click(function() {
        var posters = [];
        $('input[name="poster[]"]:checked').each(function() {
            posters.push($(this).val());
        });
        
        if (posters.length === 0) {
            layer.msg('请选择要取消的海报', {icon: 0});
            return;
        }
        
        cancelPosters(posters);
    });
    
    // 全选/全不选
    form.on('checkbox(allSelect)', function(data) {
        $('input[name="poster[]"]').prop('checked', data.elem.checked);
        form.render('checkbox');
    });
    
    // 加载海报列表
    function loadRecommendedPosters() {
        $('#poster-list').html('<tr><td colspan="6" style="text-align: center;">正在加载海报数据...</td></tr>');
        
        $.ajax({
            url: '?action=get_posters',
            type: 'GET',
            success: function(res) {
                if (res.code === 0 && res.data && res.data.length > 0) {
                    var html = '';
                    res.data.forEach(function(item) {
                        html += '<tr>';
                        html += '<td><input type="checkbox" name="poster[]" value="' + item.vod_name + '" lay-skin="primary"></td>';
                        html += '<td>' + item.vod_name + '</td>';
                        html += '<td>' + (item.type_name || '未知') + '</td>';
                        html += '<td>' + item.vod_level + '</td>';
                        
                        // 添加图片链接
                        if (item.vod_pic_slide) {
                            var shortUrl = item.vod_pic_slide.substring(0, 25) + (item.vod_pic_slide.length > 25 ? '...' : '');
                            html += '<td>';
                            html += '<a href="javascript:void(0);" class="poster-link" data-url="' + item.vod_pic_slide + '">' + shortUrl + '</a>';
                            html += '</td>';
                        } else {
                            html += '<td>无海报</td>';
                        }
                        
                        html += '<td>';
                        html += '<button type="button" class="layui-btn layui-btn-xs layui-btn-danger cancel-btn" data-name="' + item.vod_name + '">取消推荐</button>';
                        html += '</td>';
                        html += '</tr>';
                    });
                    
                    $('#poster-list').html(html);
                    
                    // 绑定链接预览事件
                    $('.poster-link').on({
                        mouseenter: function() {
                            var url = $(this).data('url');
                            var $preview = $('#poster-preview');
                            $preview.find('img').attr('src', url);
                            
                            // 定位预览图位置
                            var offset = $(this).offset();
                            var top = offset.top - $preview.height() - 10;
                            var left = offset.left;
                            
                            // 如果预览图会超出屏幕上方，则显示在元素下方
                            if (top < 0) {
                                top = offset.top + $(this).height() + 10;
                            }
                            
                            $preview.css({
                                top: top + 'px',
                                left: left + 'px',
                                display: 'block'
                            });
                        },
                        mouseleave: function() {
                            $('#poster-preview').hide();
                        },
                        click: function() {
                            var url = $(this).data('url');
                            // 大图预览
                            layer.open({
                                type: 1,
                                title: false,
                                closeBtn: 1,
                                shadeClose: true,
                                area: ['80%', '80%'],
                                content: '<div style="text-align:center;padding:20px;"><img src="' + url + '" style="max-width:100%;max-height:100%;"></div>'
                            });
                        }
                    });
                    
                    // 绑定取消按钮事件
                    $('.cancel-btn').click(function() {
                        var name = $(this).data('name');
                        cancelPosters([name]);
                    });
                    
                    // 重新渲染表单元素
                    form.render();
                } else {
                    $('#poster-list').html('<tr><td colspan="6" style="text-align: center;">暂无推荐海报</td></tr>');
                }
            },
            error: function() {
                $('#poster-list').html('<tr><td colspan="6" style="text-align: center;">加载失败，请刷新重试</td></tr>');
            }
        });
    }
    
    // 取消选中的海报推荐
    function cancelPosters(posters) {
        if (!posters || posters.length === 0) {
            return;
        }
        
        layer.confirm('确定要取消选中的 ' + posters.length + ' 个海报推荐吗？', {icon: 3, title: '提示'}, function(index) {
            layer.close(index);
            
            var loading = layer.load(2);
            
            $.ajax({
                url: '?action=cancel_poster',
                type: 'POST',
                data: {
                    action: 'cancel_selected',
                    poster: posters
                },
                success: function(res) {
                    layer.close(loading);
                    
                    if (res.code === 0) {
                        layer.msg(res.msg, {icon: 1});
                        // 重新加载海报列表
                        loadRecommendedPosters();
                    } else {
                        layer.msg(res.msg, {icon: 2});
                    }
                },
                error: function() {
                    layer.close(loading);
                    layer.msg('请求失败，请重试', {icon: 2});
                }
            });
        });
    }

    // 加载定时配置
    function loadScheduleConfig() {
        $.ajax({
            url: '?action=schedule_config',
            type: 'GET',
            success: function(res) {
                if (res.code === 0) {
                    var config = res.data;
                    
                    // 设置表单值
                    $('input[name="enabled"]').prop('checked', config.enabled);
                    $('select[name="frequency"]').val(config.frequency);
                    $('select[name="typeId"]').val(config.typeId);
                    $('input[name="count"]').val(config.count);
                    $('select[name="recommendLevel"]').val(config.recommendLevel);
                    $('input[name="clearBeforeUpdate"]').prop('checked', config.clearBeforeUpdate);
                    
                    // 重新渲染表单元素
                    form.render();
                    
                    if (config.lastUpdate > 0) {
                        var lastUpdateDate = new Date(config.lastUpdate * 1000);
                        var lastUpdateStr = lastUpdateDate.toLocaleString();
                        layer.msg('上次更新时间: ' + lastUpdateStr, {icon: 6});
                    }
                }
            }
        });
    }

    // 监听定时配置表单提交
    form.on('submit(saveSchedule)', function(data) {
        var loading = layer.load(2);
        
        $.ajax({
            url: '?action=schedule_config',
            type: 'POST',
            data: data.field,
            success: function(res) {
                layer.close(loading);
                
                if (res.code === 0) {
                    layer.msg(res.msg, {icon: 1});
                } else {
                    layer.msg(res.msg, {icon: 2});
                }
            },
            error: function() {
                layer.close(loading);
                layer.msg('提交请求失败，请重试', {icon: 2});
            }
        });
        
        return false; // 阻止表单跳转
    });

    // 复制定时任务链接
    $('#copy-schedule-url').click(function() {
        var url = $('#schedule-url').val();
        var input = document.createElement('input');
        document.body.appendChild(input);
        input.setAttribute('value', url);
        input.select();
        if (document.execCommand('copy')) {
            document.execCommand('copy');
            layer.msg('链接已复制到剪贴板', {icon: 1});
        }
        document.body.removeChild(input);
    });

    // 立即执行定时任务
    $('#test-schedule').click(function() {
        var loading = layer.load(2);
        var url = $('#schedule-url').val() + '&force=1';
        
        $.ajax({
            url: url,
            type: 'GET',
            success: function(res) {
                layer.close(loading);
                
                if (res.code === 0) {
                    layer.msg(res.msg, {icon: 1});
                    // 切换到已推荐海报选项卡
                    element.tabChange('posterTabs', 2);
                    // 重新加载海报列表
                    loadRecommendedPosters();
                } else {
                    layer.msg(res.msg, {icon: 2});
                }
            },
            error: function() {
                layer.close(loading);
                layer.msg('执行失败，请检查配置或服务器权限', {icon: 2});
            }
        });
    });

    // 监听选项卡切换，加载定时配置
    element.on('tab(posterTabs)', function(data){
        if(data.index === 3) { // 当切换到定时配置选项卡时加载配置
            loadScheduleConfig();
        }
    });

    // 加载广告设置
    function loadAdConfig() {
        $.ajax({
            url: '?action=ad_config',
            type: 'GET',
            success: function(res) {
                if (res.code === 0) {
                    var config = res.data;
                    
                    // 设置表单值
                    $('input[name="enabled"]').prop('checked', config.enabled);
                    
                    // 填充广告列表
                    var html = '';
                    if (config.ads && config.ads.length > 0) {
                        config.ads.forEach(function(ad, index) {
                            html += '<tr>';
                            html += '<td><input type="text" name="ads[' + index + '][text]" class="layui-input" value="' + ad.text + '" placeholder="广告文字"></td>';
                            html += '<td><input type="text" name="ads[' + index + '][url]" class="layui-input" value="' + ad.url + '" placeholder="链接地址"></td>';
                            html += '<td><input type="text" name="ads[' + index + '][color]" class="layui-input color-picker" value="' + ad.color + '" data-color="' + ad.color + '"></td>';
                            html += '<td><button type="button" class="layui-btn layui-btn-danger layui-btn-sm delete-ad-btn"><i class="layui-icon layui-icon-delete"></i></button></td>';
                            html += '<input type="hidden" name="ads[' + index + '][is_custom]" value="1">';
                            html += '</tr>';
                        });
                    }
                    
                    $('#ad-list').html(html);
                    
                    // 重新渲染表单元素
                    form.render();
                    
                    // 初始化颜色选择器
                    initColorPickers();
                    
                    // 加载前端广告显示
                    loadFrontAds(config);
                }
            }
        });
    }

    // 添加广告按钮点击事件
    $('#add-ad-btn').click(function() {
        var index = $('#ad-list tr').length;
        var html = '<tr>';
        html += '<td><input type="text" name="ads[' + index + '][text]" class="layui-input" placeholder="广告文字"></td>';
        html += '<td><input type="text" name="ads[' + index + '][url]" class="layui-input" placeholder="链接地址"></td>';
        html += '<td><input type="text" name="ads[' + index + '][color]" class="layui-input color-picker" value="#1E9FFF" data-color="#1E9FFF"></td>';
        html += '<td><button type="button" class="layui-btn layui-btn-danger layui-btn-sm delete-ad-btn"><i class="layui-icon layui-icon-delete"></i></button></td>';
        html += '<input type="hidden" name="ads[' + index + '][is_custom]" value="1">';
        html += '</tr>';
        
        $('#ad-list').append(html);
        
        // 重新初始化颜色选择器
        initColorPickers();
    });

    // 删除广告按钮事件委托
    $(document).on('click', '.delete-ad-btn', function() {
        $(this).parents('tr').remove();
        
        // 重新排序广告索引
        $('#ad-list tr').each(function(index) {
            $(this).find('input, select').each(function() {
                var name = $(this).attr('name');
                if (name) {
                    var newName = name.replace(/ads\[\d+\]/, 'ads[' + index + ']');
                    $(this).attr('name', newName);
                }
            });
        });
    });

    // 初始化颜色选择器
    function initColorPickers() {
        $('.color-picker').each(function() {
            var $this = $(this);
            var color = $this.val() || '#1E9FFF';
            $this.css('background-color', color);
            $this.css('color', getContrastColor(color));
        });
        
        $('.color-picker').on('input', function() {
            var $this = $(this);
            var color = $this.val();
            $this.css('background-color', color);
            $this.css('color', getContrastColor(color));
        });
    }

    // 计算对比色，用于保证文字在背景色上的可读性
    function getContrastColor(hexcolor) {
        if (!hexcolor) return '#000000';
        hexcolor = hexcolor.replace('#', '');
        
        // 如果是3位颜色代码，转换为6位
        if(hexcolor.length === 3) {
            hexcolor = hexcolor[0] + hexcolor[0] + hexcolor[1] + hexcolor[1] + hexcolor[2] + hexcolor[2];
        }
        
        var r = parseInt(hexcolor.substr(0,2),16);
        var g = parseInt(hexcolor.substr(2,2),16);
        var b = parseInt(hexcolor.substr(4,2),16);
        var yiq = ((r*299)+(g*587)+(b*114))/1000;
        return (yiq >= 128) ? '#000000' : '#ffffff';
    }

    // 监听广告设置表单提交
    form.on('submit(saveAdConfig)', function(data) {
        var loading = layer.load(2);
        
        $.ajax({
            url: '?action=ad_config',
            type: 'POST',
            data: data.field,
            success: function(res) {
                layer.close(loading);
                
                if (res.code === 0) {
                    layer.msg(res.msg, {icon: 1});
                    loadAdConfig(); // 重新加载配置
                } else {
                    layer.msg(res.msg, {icon: 2});
                }
            },
            error: function() {
                layer.close(loading);
                layer.msg('提交请求失败，请重试', {icon: 2});
            }
        });
        
        return false; // 阻止表单跳转
    });

    // 监听选项卡切换，加载广告配置
    element.on('tab(posterTabs)', function(data){
        if(data.index === 4) { // 当切换到广告设置选项卡时加载配置
            loadAdConfig();
        }
    });

    // 加载前端广告显示
    function loadFrontAds(config) {
        if (!config || !config.enabled || !config.ads || config.ads.length === 0) {
            $('#ad-container').hide();
            return;
        }
        
        var html = '';
        config.ads.forEach(function(ad) {
            html += '<a href="' + ad.url + '" class="ad-item" target="_blank" style="background-color: ' + ad.color + '">';
            html += ad.text;
            html += '</a>';
        });
        
        $('#adContent').html(html);
        $('#ad-container').show();
    }

    // 广告区域收起/展开切换
    $(document).on('click', '#adCollapseBtn, .ad-header', function() {
        var $content = $('#adContent');
        var $btn = $('#adCollapseBtn');
        
        if ($content.is(':visible')) {
            $content.slideUp();
            $btn.addClass('collapsed');
        } else {
            $content.slideDown();
            $btn.removeClass('collapsed');
        }
    });

    // 页面加载时初始化广告
    $(function() {
        $.ajax({
            url: '?action=ad_config',
            type: 'GET',
            success: function(res) {
                if (res.code === 0) {
                    loadFrontAds(res.data);
                }
            }
        });
    });
}); 