<?php
namespace addons\haibao\controller;

use think\addons\Controller;
use think\Db;
use think\Config;

class Admin extends Controller
{
    protected $model = null;
    
    public function _initialize()
    {
        parent::_initialize();
        
        // 检查用户是否登录
        if (!cmf_is_user_login()) {
            $this->error('未登录', url('user/login/index'));
        }
        
        // 管理员权限检查
        if (!cmf_is_administrator()) {
            $this->error('没有权限');
        }
        
        $this->model = model('app\common\model\Vod');
    }
    
    /**
     * 海报管理首页
     */
    public function index()
    {
        return $this->fetch();
    }
    
    /**
     * 取消所有海报推荐
     */
    public function clear()
    {
        // 清空 vod_level 字段
        $result = $this->model->where('vod_level > 0')->update(['vod_level' => 0]);
        
        return $this->success('所有海报推荐已取消', addon_url('haibao/admin/index'));
    }
    
    /**
     * 获取系统分类列表
     */
    public function getTypes()
    {
        $types = Db::name('type')->where('type_status', 1)->field('type_id,type_name')->select();
        
        return json(['code' => 0, 'data' => $types]);
    }
} 