<?php
namespace addons\haibao\controller;

use think\addons\Controller;
use think\Db;
use think\Config;

class Api extends Controller
{
    /**
     * 获取海报列表
     */
    public function posters()
    {
        $level = $this->request->param('level', 0, 'intval');
        
        $where = [];
        if ($level > 0) {
            $where['vod_level'] = ['>=', $level];
        } else {
            $where['vod_level'] = ['>', 0];
        }
        
        $posters = Db::name('vod')
            ->where($where)
            ->field('vod_id,vod_name,vod_pic,vod_pic_slide,vod_level,type_id')
            ->order('vod_level DESC, vod_time DESC')
            ->select();
            
        // 获取分类名称
        if (!empty($posters)) {
            $typeIds = array_column($posters, 'type_id');
            $typeMap = [];
            
            if (!empty($typeIds)) {
                $types = Db::name('type')->where('type_id', 'in', $typeIds)->field('type_id,type_name')->select();
                foreach ($types as $type) {
                    $typeMap[$type['type_id']] = $type['type_name'];
                }
            }
            
            foreach ($posters as &$poster) {
                $poster['type_name'] = isset($typeMap[$poster['type_id']]) ? $typeMap[$poster['type_id']] : '未知分类';
            }
        }
        
        return json(['code' => 0, 'msg' => '获取成功', 'data' => $posters]);
    }
    
    /**
     * 添加海报
     */
    public function add()
    {
        $data = $this->request->param();
        
        $movieName = isset($data['movieName']) ? trim($data['movieName']) : '';
        $recommendLevel = isset($data['recommendLevel']) ? intval($data['recommendLevel']) : 9;
        
        if (empty($movieName)) {
            return json(['code' => 1, 'msg' => '请输入影片名称']);
        }
        
        // 查询影片
        $movie = Db::name('vod')->where('vod_name', $movieName)->find();
        
        if (empty($movie)) {
            return json(['code' => 1, 'msg' => '影片不存在']);
        }
        
        // 更新推荐等级
        Db::name('vod')->where('vod_id', $movie['vod_id'])->update(['vod_level' => $recommendLevel]);
        
        return json(['code' => 0, 'msg' => '添加成功', 'data' => $movie]);
    }
    
    /**
     * 取消推荐
     */
    public function cancel()
    {
        $ids = $this->request->param('ids');
        
        if (empty($ids)) {
            return json(['code' => 1, 'msg' => '未选择任何影片']);
        }
        
        if (!is_array($ids)) {
            $ids = explode(',', $ids);
        }
        
        Db::name('vod')->where('vod_id', 'in', $ids)->update(['vod_level' => 0]);
        
        return json(['code' => 0, 'msg' => '取消推荐成功']);
    }
} 