<?php
// 显示所有错误（开发环境使用，生产环境可移除）
ini_set('display_errors', 1);
error_reporting(E_ALL);

// 定义常量
define('HAIBAO_PATH', __DIR__);
define('API_PATH', HAIBAO_PATH . '/api/');
define('CACHE_PATH', HAIBAO_PATH . '/cache/');
define('ASSETS_PATH', HAIBAO_PATH . '/assets/');

// 创建必要的目录
if (!is_dir(CACHE_PATH)) {
    @mkdir(CACHE_PATH, 0755, true);
}
if (!is_dir(API_PATH)) {
    @mkdir(API_PATH, 0755, true);
}

// 引入共享函数库
require_once API_PATH . 'common_functions.php';

// 获取系统数据库配置
$dbConfig = getSystemDbConfig();

// 处理API请求
$action = isset($_GET['action']) ? $_GET['action'] : '';

if ($action) {
    header('Content-Type: application/json; charset=utf-8');
    
    switch ($action) {
        case 'add_poster':
            include API_PATH . 'add_poster.php';
            break;
            
        case 'random_add':
            include API_PATH . 'random_add.php';
            break;
            
        case 'cancel_poster':
            include API_PATH . 'cancel_poster.php';
            break;
            
        case 'get_posters':
            include API_PATH . 'get_posters.php';
            break;
            
        case 'schedule_config':
            include API_PATH . 'schedule_config.php';
            break;
            
        case 'reset_config':
            // 删除旧配置文件
            $configFile = __DIR__ . '/config/schedule.json';
            if (file_exists($configFile)) {
                @unlink($configFile);
            }
            
            // 创建新的默认配置
            $configDir = __DIR__ . '/config';
            if (!is_dir($configDir)) {
                @mkdir($configDir, 0755, true);
            }
            
            $defaultConfig = [
                'enabled' => true,
                'frequency' => 'daily',
                'typeId' => 0,
                'count' => 10,
                'recommendLevel' => 9,
                'clearBeforeUpdate' => false,
                'lastUpdate' => 0
            ];
            
            $result = @file_put_contents($configFile, json_encode($defaultConfig, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            if ($result !== false) {
                echo json_encode(['code' => 0, 'msg' => '配置已重置']);
            } else {
                echo json_encode(['code' => 1, 'msg' => '重置配置失败，请检查目录权限']);
            }
            exit;
            break;
            
        case 'ad_config':
            include API_PATH . 'ad_config.php';
            break;
            
        default:
            echo json_encode(['code' => 1, 'msg' => '未知操作']);
            exit;
    }
}

// 获取分类列表
$types = [];
try {
    $conn = new mysqli($dbConfig['dbHost'], $dbConfig['dbUser'], $dbConfig['dbPass'], $dbConfig['dbName']);
    if (!$conn->connect_error) {
        $conn->set_charset('utf8');
        $typeSql = "SELECT type_id, type_name FROM mac_type ORDER BY type_sort";
        $typeResult = $conn->query($typeSql);
        
        if ($typeResult && $typeResult->num_rows > 0) {
            while ($row = $typeResult->fetch_assoc()) {
                $types[$row['type_id']] = $row['type_name'];
            }
        }
        
        // 获取已推荐的海报
        $recommendedSql = "SELECT vod_name FROM mac_vod WHERE vod_level > 0 ORDER BY vod_level DESC, vod_time DESC";
        $recommendedResult = $conn->query($recommendedSql);
        $recommendedPosters = [];
        
        if ($recommendedResult && $recommendedResult->num_rows > 0) {
            while ($row = $recommendedResult->fetch_assoc()) {
                $recommendedPosters[] = $row['vod_name'];
            }
        }
        
        $conn->close();
    }
} catch (Exception $e) {
    // 错误处理
}

// 引入广告加载器，获取广告HTML
include_once __DIR__ . '/includes/ad_loader.php';
$adHtml = get_ad_html();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>海报管理插件</title>
    <!-- 内联关键CSS提高加载速度 -->
    <style>
    /* 关键样式内联加载 */
    body {font-family:"Helvetica Neue",Helvetica,"PingFang SC","Microsoft YaHei",sans-serif;background-color:#f5f7f9;color:#333}
    .layui-card {border-radius:8px;box-shadow:0 1px 10px rgba(0,0,0,.05);margin-bottom:20px;border:none;transition:all .3s}
    .layui-card-header {font-weight:600;font-size:16px;padding:15px 20px;border-bottom:1px solid rgba(0,0,0,.05);background-color:rgba(250,251,252,.5);border-radius:8px 8px 0 0}
    .layui-card-body {padding:20px}
    .layui-form-label {font-weight:500;color:#555}
    .layui-input,.layui-select,.layui-textarea {border-radius:4px;transition:all .3s;border-color:#e2e2e2}
    .layui-btn {border-radius:4px;font-weight:500;transition:all .3s;box-shadow:0 2px 5px rgba(0,0,0,.1)}
    .layui-table {border-radius:6px;overflow:hidden;box-shadow:0 1px 5px rgba(0,0,0,.05)}
    .layui-tab-title .layui-this {color:#009688;font-weight:600}
    .poster-link {color:#1E9FFF;cursor:pointer;transition:all .3s;text-decoration:underline;position:relative}
    .poster-link:hover {color:#009688}
    .poster-preview {position:absolute;z-index:100;display:none;background-color:white;border-radius:8px;box-shadow:0 5px 20px rgba(0,0,0,.15);padding:5px;width:200px;height:auto}
    /* 内容推荐模块关键样式 */
    .haibao-recommend {border:1px solid #e6e6e6;border-radius:4px;margin-bottom:20px;background-color:#fff;}
    .haibao-header {padding:10px 15px;background-color:#f8f8f8;border-bottom:1px solid #e6e6e6;font-size:14px;color:#333;position:relative;cursor:pointer;}
    .haibao-toggle-btn {position:absolute;right:15px;top:50%;transform:translateY(-50%);transition:all 0.3s;}
    .haibao-items {padding:15px;display:flex;flex-wrap:wrap;gap:8px;transition:all 0.3s;}
    .haibao-item {flex:1 1 calc(16.66% - 8px);min-width:140px;padding:8px 10px;text-align:center;border-radius:4px;transition:all 0.3s;color:#fff;text-decoration:none;font-size:13px;display:block;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;box-shadow:0 2px 5px rgba(0,0,0,0.1);}
    /* 广告区域关键样式，确保首次加载时样式正确 */
    .ad-container {border:1px solid #e6e6e6;border-radius:4px;margin-bottom:20px;background-color:#fff;}
    .ad-header {padding:10px 15px;background-color:#f8f8f8;border-bottom:1px solid #e6e6e6;font-size:14px;color:#333;position:relative;cursor:pointer;}
    .ad-collapse-btn {position:absolute;right:15px;top:50%;transform:translateY(-50%);transition:all 0.3s;}
    .ad-content {padding:15px;display:flex;flex-wrap:wrap;gap:8px;transition:all 0.3s;}
    .ad-item {flex:1 1 calc(16.66% - 8px);min-width:140px;padding:8px 10px;text-align:center;border-radius:4px;transition:all 0.3s;color:#fff;text-decoration:none;font-size:13px;display:block;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;box-shadow:0 2px 5px rgba(0,0,0,0.1);}
    /* 隐藏顶部广告容器 */
    #ad-container.haibao-ad-container {
        display: none !important;
    }
    
    /* 确保已存在的广告容器正确显示 */
    .ad-content {
        display: flex !important;
        flex-wrap: wrap !important;
        gap: 8px !important;
    }
    </style>
    <link rel="stylesheet" href="https://cdn.staticfile.org/layui/2.6.8/css/layui.css">
    <link rel="stylesheet" href="<?php echo dirname($_SERVER['SCRIPT_NAME']); ?>/assets/css/style.css">
    <script src="https://cdn.staticfile.org/layui/2.6.8/layui.js"></script>
    <style>
        /* 覆盖一些基本样式 */
        .layui-card {
            border-radius: 8px;
            box-shadow: 0 2px 12px 0 rgba(0,0,0,.05);
            margin-bottom: 20px;
        }
        .layui-card-header {
            font-weight: bold;
            font-size: 16px;
            padding: 15px 20px;
            border-bottom: 1px solid #f6f6f6;
        }
        .layui-card-body {
            padding: 20px;
        }
        .poster-preview {
            position: absolute;
            z-index: 1000;
            display: none;
            max-width: 300px;
            border-radius: 4px;
            box-shadow: 0 3px 15px rgba(0,0,0,0.2);
            transition: all 0.3s ease-in-out;
        }
        .image-link {
            color: #009688;
            text-decoration: underline;
            cursor: pointer;
            position: relative;
        }
        .layui-btn {
            border-radius: 4px;
        }
        .layui-table {
            border-radius: 4px;
            overflow: hidden;
        }
        .poster-image-preview {
            width: 40px;
            height: 40px;
            object-fit: cover;
            border-radius: 4px;
            cursor: pointer;
            transition: transform 0.3s;
        }
        .poster-image-preview:hover {
            transform: scale(1.1);
        }
        /* 添加动画效果 */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .tab-container {
            animation: fadeIn 0.5s;
        }
        /* 标题样式 */
        .plugin-title {
            text-align: center;
            margin: 20px 0;
            color: #333;
            font-size: 24px;
            font-weight: bold;
        }
        /* 美化标签栏 */
        .layui-tab-title {
            border-bottom: 2px solid #009688;
        }
        .layui-tab-title .layui-this {
            color: #009688;
            font-weight: bold;
        }
        .layui-tab-title .layui-this:after {
            border-bottom-color: #009688;
            height: 2px;
        }
    </style>
</head>
<body>
    <div class="layui-fluid">
        <div class="plugin-title">海报管理</div>
        <div class="layui-row layui-col-space15">
            <div class="layui-col-md12">
                <div class="layui-card">
                    <div class="layui-card-body">
                        <div class="layui-tab" lay-filter="main-tab">
                            <ul class="layui-tab-title">
                                <li class="layui-this">手动添加</li>
                                <li>随机添加</li>
                                <li>当前海报</li>
                                <li>定时配置</li>
                            </ul>
                            <div class="layui-tab-content">
                                <!-- 集成式广告区域 - 直接替代内容推荐区域 -->
                                <?php echo $adHtml; ?>
                                
                                <!-- 手动添加海报选项卡 -->
                                <div class="layui-tab-item layui-show tab-container">
                                    <form class="layui-form" id="add-poster-form">
                                        <div class="layui-form-item">
                                            <label class="layui-form-label">影片名称</label>
                                            <div class="layui-input-block">
                                                <input type="text" name="movieName" required lay-verify="required" placeholder="请输入当前数据库内已采集的影片名称" autocomplete="off" class="layui-input">
                                            </div>
                                        </div>
                                        <div class="layui-form-item">
                                            <label class="layui-form-label">分类筛选</label>
                                            <div class="layui-input-block">
                                                <select name="typeId">
                                                    <option value="">请选择分类</option>
                                                    <?php foreach ($types as $id => $name): ?>
                                                    <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($name); ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="layui-form-item">
                                            <label class="layui-form-label">选择推荐</label>
                                            <div class="layui-input-block">
                                                <select name="recommendLevel">
                                                    <option value="9">推荐9(默认)</option>
                                                    <option value="8">推荐8</option>
                                                    <option value="7">推荐7</option>
                                                    <option value="6">推荐6</option>
                                                    <option value="5">推荐5</option>
                                                    <option value="4">推荐4</option>
                                                    <option value="3">推荐3</option>
                                                    <option value="2">推荐2</option>
                                                    <option value="1">推荐1</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="layui-form-item">
                                            <div class="layui-input-block">
                                                <button class="layui-btn" lay-submit lay-filter="addPoster"><i class="layui-icon layui-icon-add-1"></i> 添加海报</button>
                                                <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                
                                <!-- 随机添加海报选项卡 -->
                                <div class="layui-tab-item tab-container">
                                    <form class="layui-form" id="random-add-form">
                                        <div class="layui-form-item">
                                            <label class="layui-form-label">分类筛选</label>
                                            <div class="layui-input-block">
                                                <select name="typeId">
                                                    <option value="">请选择分类</option>
                                                    <?php foreach ($types as $id => $name): ?>
                                                    <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($name); ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="layui-form-item">
                                            <label class="layui-form-label">添加数量</label>
                                            <div class="layui-input-block">
                                                <input type="number" name="count" min="1" max="50" value="5" required lay-verify="required|number" class="layui-input">
                                            </div>
                                        </div>
                                        <div class="layui-form-item">
                                            <label class="layui-form-label">选择推荐</label>
                                            <div class="layui-input-block">
                                                <select name="recommendLevel">
                                                    <option value="9">推荐9(默认)</option>
                                                    <option value="8">推荐8</option>
                                                    <option value="7">推荐7</option>
                                                    <option value="6">推荐6</option>
                                                    <option value="5">推荐5</option>
                                                    <option value="4">推荐4</option>
                                                    <option value="3">推荐3</option>
                                                    <option value="2">推荐2</option>
                                                    <option value="1">推荐1</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="layui-form-item">
                                            <div class="layui-input-block">
                                                <button class="layui-btn" lay-submit lay-filter="randomAdd"><i class="layui-icon layui-icon-upload"></i> 随机添加</button>
                                                <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                
                                <!-- 已推荐海报选项卡 -->
                                <div class="layui-tab-item tab-container">
                                    <div class="layui-btn-group" style="margin-bottom: 15px;">
                                        <button type="button" class="layui-btn layui-btn-danger" id="cancel-all"><i class="layui-icon layui-icon-delete"></i> 取消所有推荐</button>
                                        <button type="button" class="layui-btn" id="cancel-selected"><i class="layui-icon layui-icon-delete"></i> 取消选中推荐</button>
                                    </div>
                                    
                                    <table class="layui-table">
                                        <thead>
                                            <tr>
                                                <th style="width: 50px;"><input type="checkbox" lay-skin="primary" lay-filter="allSelect"></th>
                                                <th>名称</th>
                                                <th>分类</th>
                                                <th>推荐等级</th>
                                                <th style="width: 100px;">图片链接</th>
                                                <th>操作</th>
                                            </tr>
                                        </thead>
                                        <tbody id="poster-list">
                                            <!-- 海报列表将通过AJAX加载 -->
                                            <tr>
                                                <td colspan="6" style="text-align: center;">正在加载海报数据...</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                
                                <!-- 定时配置选项卡 -->
                                <div class="layui-tab-item tab-container">
                                    <div class="layui-card">
                                        <div class="layui-card-header">
                                            <i class="layui-icon layui-icon-time"></i> 定时更新配置
                                        </div>
                                        <div class="layui-card-body">
                                            <form class="layui-form" id="schedule-config-form">
                                                <div class="layui-form-item">
                                                    <label class="layui-form-label">定时更新</label>
                                                    <div class="layui-input-block">
                                                        <input type="checkbox" name="enabled" value="1" lay-skin="switch" lay-text="开启|关闭" id="schedule-enabled">
                                                    </div>
                                                </div>
                                                
                                                <div class="layui-form-item">
                                                    <label class="layui-form-label">执行方式</label>
                                                    <div class="layui-input-block">
                                                        <div class="layui-form-mid layui-word-aux">每次访问链接时立即执行一次更新</div>
                                                    </div>
                                                </div>
                                                
                                                <div class="layui-form-item">
                                                    <label class="layui-form-label">分类筛选</label>
                                                    <div class="layui-input-block">
                                                        <select name="typeId">
                                                            <option value="">全部分类</option>
                                                            <?php foreach ($types as $id => $name): ?>
                                                            <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($name); ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                                <div class="layui-form-item">
                                                    <label class="layui-form-label">更新数量</label>
                                                    <div class="layui-input-inline">
                                                        <input type="number" name="count" min="1" max="50" value="10" required lay-verify="required|number" class="layui-input">
                                                    </div>
                                                    <div class="layui-form-mid layui-word-aux">每次更新的海报数量</div>
                                                </div>
                                                
                                                <div class="layui-form-item">
                                                    <label class="layui-form-label">选择推荐</label>
                                                    <div class="layui-input-inline">
                                                        <select name="recommendLevel">
                                                            <option value="9">推荐9(默认)</option>
                                                            <option value="8">推荐8</option>
                                                            <option value="7">推荐7</option>
                                                            <option value="6">推荐6</option>
                                                            <option value="5">推荐5</option>
                                                            <option value="4">推荐4</option>
                                                            <option value="3">推荐3</option>
                                                            <option value="2">推荐2</option>
                                                            <option value="1">推荐1</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                                <div class="layui-form-item">
                                                    <label class="layui-form-label">更新前操作</label>
                                                    <div class="layui-input-block">
                                                        <input type="checkbox" name="clearBeforeUpdate" value="1" title="清空当前推荐" lay-skin="primary">
                                                    </div>
                                                </div>
                                                
                                                <div class="layui-form-item">
                                                    <div class="layui-input-block">
                                                        <button class="layui-btn" lay-submit lay-filter="saveSchedule"><i class="layui-icon layui-icon-ok"></i> 保存配置</button>
                                                        <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                                                    </div>
                                                </div>
                                            </form>
                                            
                                            <div class="layui-card">
                                                <div class="layui-card-header">定时任务链接</div>
                                                <div class="layui-card-body">
                                                    <div class="layui-form-item">
                                                        <label class="layui-form-label">访问链接</label>
                                                        <div class="layui-input-block">
                                                            <input type="text" id="schedule-url" class="layui-input" readonly value="<?php echo 'http://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['SCRIPT_NAME']).'/api/schedule_update.php?key='.md5('haibao_schedule_key'); ?>">
                                                        </div>
                                                    </div>
                                                    <div class="layui-form-item">
                                                        <div class="layui-input-block">
                                                            <button type="button" class="layui-btn layui-btn-normal" id="copy-schedule-url"><i class="layui-icon layui-icon-share"></i> 复制链接</button>
                                                            <button type="button" class="layui-btn layui-btn-warm" id="test-schedule"><i class="layui-icon layui-icon-refresh"></i> 立即执行一次</button>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="layui-collapse" lay-filter="scheduleHelp">
                                                        <div class="layui-colla-item">
                                                            <h2 class="layui-colla-title">宝塔面板定时任务设置说明</h2>
                                                            <div class="layui-colla-content">
                                                                <p>1. 登录宝塔面板，点击左侧【计划任务】</p>
                                                                <p>2. 点击【添加计划任务】</p>
                                                                <p>3. 任务类型选择【访问URL】</p>
                                                                <p>4. 任务名称输入【海报定时更新】</p>
                                                                <p>5. 执行周期根据您需要的频率设置（每小时/每天/每周等）</p>
                                                                <p>6. URL地址填写上面的访问链接</p>
                                                                <p>7. 点击提交即可</p>
                                                                <p>8. <b style="color:red">每次访问链接都会执行一次海报更新，请根据实际需求设置执行频率</b></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- 预览图片容器，优化位置和大小 -->
    <div class="poster-preview" id="poster-preview" style="display:none;width:300px;max-height:400px;overflow:hidden;">
        <img src="" alt="海报预览" style="width:100%;border-radius:4px;object-fit:contain;max-height:400px;">
    </div>
    
    <!-- 在页面顶部添加更新通知区域 -->
    <div class="update-notification" id="updateNotification" style="display:none;">
        <div class="layui-card">
            <div class="layui-card-header">
                <i class="layui-icon layui-icon-notice"></i> 
                <span>发现新版本</span>
                <button type="button" class="layui-btn layui-btn-xs layui-btn-normal" id="updateButton">
                    立即更新
                </button>
                <button type="button" class="layui-btn layui-btn-xs layui-btn-primary" id="ignoreUpdateButton">
                    忽略
                </button>
            </div>
            <div class="layui-card-body">
                <div id="updateInfo">正在检查更新...</div>
            </div>
        </div>
    </div>
    
    <script src="<?php echo dirname($_SERVER['SCRIPT_NAME']); ?>/assets/js/script.js"></script>
    <script>
    // 页面加载优化
    document.addEventListener('DOMContentLoaded', function() {
        // 延迟加载非关键CSS
        setTimeout(function() {
            var cssLink = document.createElement('link');
            cssLink.rel = 'stylesheet';
            cssLink.href = '<?php echo dirname($_SERVER['SCRIPT_NAME']); ?>/assets/css/style.css';
            document.head.appendChild(cssLink);
        }, 100);
    });

    // 检查更新
    function checkForUpdates() {
        fetch('api/update_check.php')
            .then(response => response.json())
            .then(data => {
                if (data.success && data.has_update) {
                    // 显示更新通知
                    document.getElementById('updateNotification').style.display = 'block';
                    
                    // 更新内容
                    var updateInfo = '<p><strong>当前版本:</strong> ' + data.current_version + '</p>';
                    updateInfo += '<p><strong>最新版本:</strong> ' + data.latest_version + '</p>';
                    updateInfo += '<p><strong>更新内容:</strong></p>';
                    updateInfo += '<ul>';
                    
                    if (data.changelog && data.changelog.length > 0) {
                        data.changelog.forEach(function(item) {
                            updateInfo += '<li>' + item + '</li>';
                        });
                    } else {
                        updateInfo += '<li>优化系统性能和稳定性</li>';
                    }
                    
                    updateInfo += '</ul>';
                    
                    document.getElementById('updateInfo').innerHTML = updateInfo;
                    
                    // 绑定更新按钮事件
                    document.getElementById('updateButton').addEventListener('click', function() {
                        performUpdate(data.latest_version);
                    });
                    
                    // 绑定忽略按钮事件
                    document.getElementById('ignoreUpdateButton').addEventListener('click', function() {
                        document.getElementById('updateNotification').style.display = 'none';
                    });
                }
            })
            .catch(error => {
                console.error('检查更新失败:', error);
            });
    }

    // 执行更新
    function performUpdate(version) {
        // 显示更新中提示
        layer.msg('正在下载并安装更新，请稍候...', {
            icon: 16,
            shade: 0.3,
            time: 0
        });
        
        // 请求更新接口
        fetch('api/update_download.php?version=' + version)
            .then(response => response.json())
            .then(data => {
                layer.closeAll();
                
                if (data.code === 0) {
                    layer.alert(data.msg, {
                        icon: 1,
                        title: '更新成功',
                        btn: ['刷新页面'],
                        yes: function(index) {
                            layer.close(index);
                            location.reload();
                        }
                    });
                } else {
                    layer.alert(data.msg, {
                        icon: 2,
                        title: '更新失败'
                    });
                }
            })
            .catch(error => {
                layer.closeAll();
                layer.alert('更新过程中发生错误: ' + error.message, {
                    icon: 2,
                    title: '更新失败'
                });
            });
    }

    // 页面加载后检查更新
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(checkForUpdates, 1000);
    });
    </script>
</body>
</html> 