<?php
// 安装脚本 - 创建必要目录并设置权限

// 定义所需目录
$directories = [
    'config',
    'logs',
    'cache',
    'temp'
];

$basePath = __DIR__;

// 创建目录
foreach ($directories as $dir) {
    $path = $basePath . '/' . $dir;
    if (!is_dir($path)) {
        if (!@mkdir($path, 0755, true)) {
            echo "警告: 无法创建目录 {$path}, 请手动创建并设置权限为755<br>";
        } else {
            echo "成功: 创建目录 {$path}<br>";
        }
    } else {
        echo "信息: 目录 {$path} 已存在<br>";
    }
    
    // 测试写入权限
    $testFile = $path . '/test.txt';
    if (file_put_contents($testFile, 'test')) {
        echo "成功: 目录 {$path} 可写入<br>";
        unlink($testFile); // 清理测试文件
    } else {
        echo "警告: 目录 {$path} 不可写入，请设置权限为755<br>";
    }
}

echo "<br>如果看到警告信息，请执行以下Shell命令：<br>";
echo "<pre>chmod -R 755 {$basePath}/config {$basePath}/logs {$basePath}/cache {$basePath}/temp</pre>";
echo "<pre>chown -R www:www {$basePath}/config {$basePath}/logs {$basePath}/cache {$basePath}/temp</pre>";
echo "<br><a href='index.php'>返回插件首页</a>"; 