<?php
// 测试文件 - 检查系统环境和配置状态

header('Content-Type: text/html; charset=utf-8');
echo '<h1>海报插件环境测试</h1>';

// 检查PHP版本
echo '<h2>PHP环境</h2>';
echo 'PHP版本: ' . phpversion() . '<br>';
echo '允许执行时间: ' . ini_get('max_execution_time') . '秒<br>';
echo '内存限制: ' . ini_get('memory_limit') . '<br>';

// 检查目录权限
echo '<h2>目录权限</h2>';
$directories = [
    'api',
    'config',
    'logs',
    'cache',
    'temp'
];

$basePath = __DIR__;
foreach ($directories as $dir) {
    $path = $basePath . '/' . $dir;
    if (!is_dir($path)) {
        echo "{$dir}: <span style='color:red'>不存在</span><br>";
    } else {
        echo "{$dir}: <span style='color:green'>存在</span>, ";
        if (is_writable($path)) {
            echo "<span style='color:green'>可写</span><br>";
        } else {
            echo "<span style='color:red'>不可写</span><br>";
        }
    }
}

// 检查配置文件
echo '<h2>配置文件</h2>';
$configFile = $basePath . '/config/schedule.json';
if (file_exists($configFile)) {
    echo "配置文件: <span style='color:green'>存在</span><br>";
    $configContent = @file_get_contents($configFile);
    if ($configContent !== false) {
        $config = @json_decode($configContent, true);
        if ($config !== null) {
            echo "配置状态: <span style='color:green'>正确</span><br>";
            echo "配置内容:<br><pre>" . htmlspecialchars($configContent) . "</pre>";
            
            // 检查定时状态
            $enabled = isset($config['enabled']) ? $config['enabled'] : false;
            if ($enabled) {
                echo "定时更新: <span style='color:green'>已启用</span><br>";
            } else {
                echo "定时更新: <span style='color:orange'>未启用</span><br>";
            }
        } else {
            echo "配置状态: <span style='color:red'>JSON格式错误</span><br>";
            echo "错误原因: " . json_last_error_msg() . "<br>";
            echo "原始内容:<br><pre>" . htmlspecialchars($configContent) . "</pre>";
        }
    } else {
        echo "配置状态: <span style='color:red'>无法读取</span><br>";
    }
} else {
    echo "配置文件: <span style='color:red'>不存在</span><br>";
}

// 提供修复建议
echo '<h2>修复建议</h2>';
echo '<p>如果上述检查发现问题，请尝试以下方法:</p>';
echo '<ol>';
echo '<li>运行 <a href="install.php" target="_blank">安装脚本</a> 创建必要目录</li>';
echo '<li>手动设置权限: <pre>chmod -R 755 ' . $basePath . '</pre></li>';
echo '<li>设置所有者: <pre>chown -R www:www ' . $basePath . '</pre></li>';
echo '<li>如果配置文件有问题，<a href="index.php?action=reset_config" target="_blank">点击重置配置</a></li>';
echo '</ol>';

echo '<p><a href="index.php">返回插件首页</a></p>'; 